using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

class Program
{
    class Fenwick
    {
        public int N;
        long[] bit;
        public Fenwick(int n) { N = n; bit = new long[n + 1]; }
        public void Add(int idx, long val) { for (; idx <= N; idx += idx & -idx) bit[idx] += val; }
        public long SumPrefix(int idx) { long s = 0; for (; idx > 0; idx -= idx & -idx) s += bit[idx]; return s; }
        public long SumRange(int l, int r) { if (r < l) return 0; return SumPrefix(r) - SumPrefix(l - 1); }
        public int FindByPrefix(long k)
        {
            int idx = 0;
            int bitMask = 1;
            while (bitMask << 1 <= N) bitMask <<= 1;
            for (int d = bitMask; d > 0; d >>= 1)
            {
                int next = idx + d;
                if (next <= N && bit[next] < k)
                {
                    idx = next;
                    k -= bit[next];
                }
            }
            return idx + 1;
        }
    }

    struct Query { public int t, x, y; }

    static void Main()
    {
        string[] first = Console.ReadLine().Split();
        int N = int.Parse(first[0]);
        int Q = int.Parse(first[1]);

        int[] a = Console.ReadLine().Split().Select(int.Parse).ToArray();
        Query[] queries = new Query[Q];
        for (int i = 0; i < Q; i++)
        {
            int[] line = Console.ReadLine().Split().Select(int.Parse).ToArray();
            queries[i].t = line[0];
            if (queries[i].t == 1) { queries[i].x = line[1]; queries[i].y = 0; }
            else { queries[i].x = line[1]; queries[i].y = line[2]; }
        }

        int maxVal = N;
        int[] cnt = new int[maxVal + 1];
        for (int i = 0; i < N; i++) cnt[a[i]]++;

        HashSet<long> weightSet = new HashSet<long>();
        for (int v = 1; v <= maxVal; v++)
            if (cnt[v] > 0) weightSet.Add((long)v * cnt[v]);

        int[] curA = new int[N];
        Array.Copy(a, curA, N);
        int[] simCnt = new int[maxVal + 1];
        Array.Copy(cnt, simCnt, maxVal + 1);

        foreach (Query q in queries)
        {
            if (q.t == 2)
            {
                int pos = q.x - 1;
                int old = curA[pos];
                int nw = q.y;
                if (old == nw) { curA[pos] = nw; continue; }

                simCnt[old]--;
                if (simCnt[old] > 0) weightSet.Add((long)old * simCnt[old]);
                simCnt[nw]++;
                weightSet.Add((long)nw * simCnt[nw]);

                curA[pos] = nw;
            }
        }

        if (weightSet.Contains(0L)) weightSet.Remove(0L);

        List<long> weights = weightSet.ToList();
        weights.Sort();
        int M = weights.Count;
        Dictionary<long, int> weightToIndex = new Dictionary<long, int>(M);
        for (int i = 0; i < M; i++) weightToIndex[weights[i]] = i + 1;

        Array.Clear(cnt, 0, cnt.Length);
        for (int i = 0; i < N; i++) cnt[a[i]]++;

        int[] curIndex = new int[maxVal + 1];

        Fenwick bitCount = new Fenwick(Math.Max(1, M));
        Fenwick bitSum = new Fenwick(Math.Max(1, M));
        long totalDistinct = 0;
        long totalWeightsSum = 0;

        for (int v = 1; v <= maxVal; v++)
        {
            if (cnt[v] > 0)
            {
                long w = (long)v * cnt[v];
                int idx = weightToIndex[w];
                curIndex[v] = idx;
                bitCount.Add(idx, 1);
                bitSum.Add(idx, w);
                totalDistinct++;
                totalWeightsSum += w;
            }
        }

        StringBuilder sb = new StringBuilder();
        for (int qi = 0; qi < Q; qi++)
        {
            Query q = queries[qi];
            if (q.t == 1)
            {
                int k = q.x;
                int m = N - k;
                if (m >= totalDistinct)
                {
                    sb.AppendLine("0");
                }
                else
                {
                    long kRem = totalDistinct - m;
                    if (kRem == 0) { sb.AppendLine("0"); continue; }
                    int idx = bitCount.FindByPrefix(kRem);
                    long cntBefore = bitCount.SumPrefix(idx - 1);
                    long sumBefore = bitSum.SumPrefix(idx - 1);
                    long weightAtIdx = weights[idx - 1];
                    long takeFromIdx = kRem - cntBefore;
                    long ans = sumBefore + takeFromIdx * weightAtIdx;
                    sb.AppendLine(ans.ToString());
                }
            }
            else
            {
                int pos = q.x - 1;
                int old = a[pos];
                int nw = q.y;
                if (old == nw) { a[pos] = nw; continue; }

                {
                    int prevCnt = cnt[old];
                    long prevWeight = (long)old * prevCnt;
                    int prevIdx = curIndex[old];
                    if (prevIdx != 0)
                    {
                        bitCount.Add(prevIdx, -1);
                        bitSum.Add(prevIdx, -prevWeight);
                        totalDistinct--;
                        totalWeightsSum -= prevWeight;
                    }
                    cnt[old]--;
                    if (cnt[old] > 0)
                    {
                        long newWeight = (long)old * cnt[old];
                        int newIdx = weightToIndex[newWeight];
                        curIndex[old] = newIdx;
                        bitCount.Add(newIdx, 1);
                        bitSum.Add(newIdx, newWeight);
                        totalDistinct++;
                        totalWeightsSum += newWeight;
                    }
                    else
                    {
                        curIndex[old] = 0;
                    }
                }

                {
                    int prevCnt = cnt[nw];
                    if (prevCnt > 0)
                    {
                        long prevWeight = (long)nw * prevCnt;
                        int prevIdx = curIndex[nw];
                        if (prevIdx != 0)
                        {
                            bitCount.Add(prevIdx, -1);
                            bitSum.Add(prevIdx, -prevWeight);
                            totalDistinct--;
                            totalWeightsSum -= prevWeight;
                        }
                    }
                    cnt[nw]++;
                    long newWeight = (long)nw * cnt[nw];
                    int newIdx = weightToIndex[newWeight];
                    curIndex[nw] = newIdx;
                    bitCount.Add(newIdx, 1);
                    bitSum.Add(newIdx, newWeight);
                    totalDistinct++;
                    totalWeightsSum += newWeight;
                }

                a[pos] = nw;
            }
        }

        Console.Write(sb.ToString());
    }
}